import { useNavigation } from "@react-navigation/core";
import React from "react";
import { Text, Pressable } from "react-native";

import { BASE_API_URL_STG } from "@env";
import ProgressiveImage from "../../../src/components/ProgressiveImage";
import { categoriesStyle } from "./featureCategoriesStyle";
import useLangTranslation from "../../../hooks/useLangTranslation";

const SingleCategory = ({ item, index, topCategory }) => {
    const {trans} = useLangTranslation();
    const navigation = useNavigation();
    const handleNavigate = () => {
        const url = `${BASE_API_URL_STG}/user/products?categories=${item.slug}`;
        navigation.navigate("feature display", {
            name: item.name,
            url,
        });
    };
    return (
        <Pressable
            onPress={handleNavigate}
            style={[
                categoriesStyle.item,
                categoriesStyle.categoryItemNameCont(topCategory.length - 1, index)
            ]}
        >
            <ProgressiveImage
                source={{ uri: item?.picture_url }}
                style={categoriesStyle.img}
            />
            <Text style={categoriesStyle.text}>{trans(item.name)}</Text>
        </Pressable>
    );
};

export default SingleCategory;
